#!/usr/bin/perl

use strict;
use warnings;
use MM::Database;
use IPC::Run qw(run timeout);

#change this to 'rCRS' to get data for the Cambridge sequence
my $reference = 'consensus';


my $database = MM::Database->new();
my $runlength_counts = $database->get_counts_runlength([], $reference);

#create a filehandle for the octave script
open (my $OCT, '>', '/tmp/octave_script');
print $OCT "#!/opt/local/bin/octave\n\n";
print "set (0, \"defaultlinecolor\", \"black\")\n;";

#create the plot for the runlength
print $OCT "A=[";
for (sort {$a <=> $b} keys %{$runlength_counts}){
    print $OCT $_ , ',';
}
print $OCT "];\n";


print $OCT "B=[";
for (sort {$a <=> $b} keys %{$runlength_counts}){
    print $OCT $runlength_counts->{$_} , ',';
}
print $OCT "];\n";

print $OCT "plot(A,B,'k.+')\n";
print $OCT "xlabel(\"runlength\")\n";
print $OCT "ylabel (\"counts\")\n";
print $OCT "ax = gca()\n";
print $OCT "set (ax, \"xlim\", [0,15000])\n";
print $OCT "set (ax, \"ylim\", [0,3000])\n";
print $OCT "print -deps /tmp/runlength.eps\n";
print $OCT "print -dps2 /tmp/runlength.ps\n";
print $OCT "close\n";


#create the plot for the log runlength
print $OCT "A=[";
for (sort {$runlength_counts->{$b} <=> $runlength_counts->{$a}} keys %{$runlength_counts}){
    if ($_){
        print $OCT log($_) , ',';        
    }
    else{
        print $OCT "0,"
    }
}
print $OCT "];\n";


print $OCT "B=[";
for (sort {$runlength_counts->{$b} <=> $runlength_counts->{$a}} keys %{$runlength_counts}){
    if ($_){
        print $OCT log ($runlength_counts->{$_}) , ',';
    }
    else{
        print $OCT "0,";
    }
}
print $OCT "];\n";

print $OCT "plot(A,B,'k.+')\n";
print $OCT "xlabel(\"log of runlength rank\")\n";
print $OCT "ylabel (\"log of counts\")\n";
print $OCT "ax = gca()\n";
print $OCT "set (ax, \"xlim\", [0,8])\n";
print $OCT "set (ax, \"ylim\", [0,8])\n";
print $OCT "print -deps /tmp/log_runlength.eps\n";
print $OCT "print -dps2 /tmp/log_runlength.ps\n";


#run the script and cleanup
close $OCT;
chmod 0755, "/tmp/octave_script";
system "/tmp/octave_script";
unlink "/tmp/octave_script";


#get the encoding ID
my $dbh = $database->dbh();

my ($encoding_set_id) = $dbh->selectrow_array(q{
    SELECT max(encoding_set)
    FROM mitomaster.huffmanvar
    WHERE reference = ?}, undef, ($reference));  

my $array_ref = $dbh->selectall_arrayref(
    qq{SELECT variant, count, code
      FROM mitomaster.huffmanvar
      WHERE
        encoding_set = ?
      ORDER BY count DESC}, undef, ($encoding_set_id));


open (my $OUT, '>', '/tmp/huffman_encoding.tsv') or die "Could not open outfile.";
for (my $j = 0; $j < @{$array_ref}; $j++){
    print $OUT "$array_ref->[$j][0]\t$array_ref->[$j][1]\t$array_ref->[$j][2]\n";
}
close $OUT;
